rule Win32_Ransomware_Teslacrypt : tc_detection malicious
{
    meta:

        author            = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "TESLACRYPT"
        description         = "Yara rule that detects Teslacrypt ransomware."

        tc_detection_type = "Ransomware"
        tc_detection_name = "Teslacrypt"

    strings:
        $file_search_0_3_1_1 = {
            B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C4 89 84 24 ?? ?? ?? ?? 55 56 8B B4 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 84 
            24 ?? ?? ?? ?? 6A ?? 50 66 C7 84 24 ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 56 8D 8C 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? 
            ?? ?? 68 ?? ?? ?? ?? 8D 94 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 8D 44 24 ?? 50 8D 8C 24 ?? ?? ?? ?? 
            51 FF 15 ?? ?? ?? ?? 8B E8 83 FD ?? 0F 84 B5 01 00 00 53 8B 1D ?? ?? ?? ?? 57 8B BC 24 ?? ?? ?? ?? 8D A4 24 ?? ?? ?? ?? 
            83 3D ?? ?? ?? ?? ?? 0F 85 89 01 00 00 F6 44 24 ?? ?? 0F 84 D2 00 00 00 8D 4C 24 ?? B8 ?? ?? ?? ?? 66 8B 10 66 3B 11 75 
            1E 66 85 D2 74 15 66 8B 50 ?? 66 3B 51 ?? 75 0F 83 C0 ?? 83 C1 ?? 66 85 D2 75 DE 33 C0 EB 05 1B C0 83 D8 ?? 85 C0 0F 84 
            29 01 00 00 8D 4C 24 ?? B8 ?? ?? ?? ?? 8D 49 ?? 66 8B 10 66 3B 11 75 1E 66 85 D2 74 15 66 8B 50 ?? 66 3B 51 ?? 75 0F 83 
            C0 ?? 83 C1 ?? 66 85 D2 75 DE 33 C0 EB 05 1B C0 83 D8 ?? 85 C0 0F 84 EA 00 00 00 56 8D 94 24 ?? ?? ?? ?? 68
        }

        $file_search_0_3_1_2 = { 
            52 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8D 4C 24 ?? 51 8D 94 24 ?? ?? ?? 
            ?? 68 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 57 50 E8 7E FE FF FF 83 C4 ?? E9 93 00 00 00 56 8D 8C 24 ?? ?? 
            ?? ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 94 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 8D 44 24 ?? 
            50 8D 8C 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 8D 54 24 ?? 68 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 
            85 FF 74 25 85 C0 75 35 8D 44 24 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 83 F8 ?? 75 23 8D 8C 24 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? EB 
            11 85 C0 74 10 8D 84 24 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 4C 24 ?? 51 55 FF D3 85 C0 74 0D 83 3D ?? ?? ?? ?? ?? 
            0F 84 6A FE FF FF 55 FF 15 ?? ?? ?? ?? 5F 5B 8B 8C 24 ?? ?? ?? ?? 5E 5D 33 CC E8 ?? ?? ?? ?? 81 C4 ?? ?? ?? ?? C3 
        }

        $file_search_0_3_3_1 = {
            B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C4 89 84 24 ?? ?? ?? ?? 55 56 8B B4 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 84 
            24 ?? ?? ?? ?? 6A ?? 50 66 C7 84 24 ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 56 8D 8C 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? 
            ?? ?? 68 ?? ?? ?? ?? 8D 94 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 8D 44 24 ?? 50 8D 8C 24 ?? ?? ?? ?? 
            51 FF 15 ?? ?? ?? ?? 8B E8 83 FD ?? 0F 84 57 02 00 00 53 8B 1D ?? ?? ?? ?? 57 8B BC 24 ?? ?? ?? ?? 8D A4 24 ?? ?? ?? ?? 
            83 3D ?? ?? ?? ?? ?? 0F 85 2B 02 00 00 F6 44 24 ?? ?? 0F 84 74 01 00 00 8D 4C 24 ?? B8 ?? ?? ?? ?? 66 8B 10 66 3B 11 75 
            1E 66 85 D2 74 15 66 8B 50 ?? 66 3B 51 ?? 75 0F 83 C0 ?? 83 C1 ?? 66 85 D2 75 DE 33 C0 EB 05 1B C0 83 D8 ?? 85 C0 0F 84 
            CB 01 00 00 8D 4C 24 ?? B8 ?? ?? ?? ?? 8D 49 ?? 66 8B 10 66 3B 11 75 1E 66 85 D2 74 15 66 8B 50 ?? 66 3B 51 ?? 75 0F 83 
            C0 ?? 83 C1 ?? 66 85 D2 75 DE 33 C0 EB 05 1B C0 83 D8 ?? 85 C0 0F 84 8C 01 00 00 56 8D 94 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 
            52 E8 ?? ?? ?? ?? 8B C6 83 C4 ?? 8D 50 ?? 8B FF 66 8B 08 83 C0 ?? 66 85 C9 75 F5 2B C2 D1 F8 83 F8 ?? 76 1A 68 ?? ?? ?? 
            ?? 8D 84 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 4C 24 ?? 51 8D 94 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 52
        }

        $file_search_0_3_3_2 = { 
            E8 ?? ?? ?? ?? 83 C4 ?? 8D 8C 24 ?? ?? ?? ?? B8 ?? ?? ?? ?? 66 8B 10 66 3B 11 75 1E 66 85 D2 74 15 66 8B 50 ?? 66 3B 51 
            ?? 75 0F 83 C0 ?? 83 C1 ?? 66 85 D2 75 DE 33 C0 EB 05 1B C0 83 D8 ?? 85 C0 0F 84 E8 00 00 00 8D 8C 24 ?? ?? ?? ?? B8 ?? 
            ?? ?? ?? 66 8B 10 66 3B 11 75 1E 66 85 D2 74 15 66 8B 50 ?? 66 3B 51 ?? 75 0F 83 C0 ?? 83 C1 ?? 66 85 D2 75 DE 33 C0 EB 
            05 1B C0 83 D8 ?? 85 C0 0F 84 A9 00 00 00 8D 84 24 ?? ?? ?? ?? 57 50 E8 DC FD FF FF 83 C4 ?? E9 93 00 00 00 56 8D 8C 24 
            ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 94 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 8D 44 
            24 ?? 50 8D 8C 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 8D 54 24 ?? 68 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 
            C4 ?? 85 FF 74 25 85 C0 75 35 8D 44 24 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 83 F8 ?? 75 23 8D 8C 24 ?? ?? ?? ?? 51 E8 ?? ?? ?? 
            ?? EB 11 85 C0 74 10 8D 84 24 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 4C 24 ?? 51 55 FF D3 85 C0 74 0D 83 3D ?? ?? ?? 
            ?? ?? 0F 84 C8 FD FF FF 55 FF 15 ?? ?? ?? ?? 5F 5B 8B 8C 24 ?? ?? ?? ?? 5E 5D 33 CC E8 ?? ?? ?? ?? 81 C4 ?? ?? ?? ?? C3 
        }

        $file_search_0_3_4a_1 = {
            B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C4 89 84 24 ?? ?? ?? ?? 55 56 8B B4 24 ?? ?? ?? ?? 57 33 FF 68 ?? ?? ?? 
            ?? 8D 84 24 ?? ?? ?? ?? 57 50 66 89 BC 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8C 24 ?? ?? ?? ?? 57 51 66 89 BC 
            24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 56 8D 94 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? 
            ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 4C 24 ?? 51 8D 94 24 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 8B E8 83 FD ?? 0F 
            84 99 02 00 00 8B BC 24 ?? ?? ?? ?? 53 8B 1D ?? ?? ?? ?? 83 3D ?? ?? ?? ?? ?? 0F 85 76 02 00 00 F6 44 24 ?? ?? 0F 84 6B 
            01 00 00 8D 44 24 ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 0F 84 38 02 00 00 8D 4C 24 ?? 51 68 ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 83 C4 ?? 85 C0 0F 84 1E 02 00 00 56 8D 94 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 
            83 C4 ?? 83 F8 ?? 76 1A 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 4C 24 ?? 51 8D 
            94 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 
            0F 84 AF 01 00 00 8D 8C 24 ?? ?? ?? ?? 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 0F 84 92 01 00 00 8D 94 24 ?? ?? 
            ?? ?? 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 0F 84 75 01 00 00 8D 84 24 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? E8
        }

        $file_search_0_3_4a_2 = { 
            83 C4 ?? 85 C0 0F 84 58 01 00 00 8D 8C 24 ?? ?? ?? ?? 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 0F 84 3B 01 
            00 00 8D 94 24 ?? ?? ?? ?? 57 52 E8 10 FE FF FF 8D 84 24 ?? ?? ?? ?? 50 8D 8C 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? 
            ?? ?? 68 ?? ?? ?? ?? 8D 94 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 
            ?? E9 E7 00 00 00 56 8D 8C 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 94 24 ?? ?? ?? ?? 68 ?? ?? 
            ?? ?? 52 E8 ?? ?? ?? ?? 8D 44 24 ?? 50 8D 8C 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 85 FF 74 79 8D 54 
            24 ?? 52 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 0F 85 7F 00 00 00 8D 44 24 ?? 50 E8 ?? ?? ?? ?? 
            68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 63 8D 4C 24 ?? 51 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 
            C4 ?? 85 C0 75 47 8D 54 24 ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 83 F8 ?? 75 35 8D 84 24 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? EB 23 8D 
            4C 24 ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 74 10 8D 94 24 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 8D 44 24 
            ?? 50 55 FF D3 85 C0 74 0D 83 3D ?? ?? ?? ?? ?? 0F 84 7D FD FF FF 55 FF 15 ?? ?? ?? ?? 5B 8B 8C 24 ?? ?? ?? ?? 5F 5E 5D 
            33 CC E8 ?? ?? ?? ?? 81 C4 ?? ?? ?? ?? C3 
        }

        $file_search_0_3_5a_1 = {
            B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C4 89 84 24 ?? ?? ?? ?? 53 55 8B AC 24 ?? ?? ?? ?? 57 68 ?? ?? ?? ?? 8D 
            84 24 ?? ?? ?? ?? 6A ?? 50 66 C7 84 24 ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 8D 8C 24 ?? ?? ?? ?? 6A 
            ?? 51 66 C7 84 24 ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 55 8D 94 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 
            C4 ?? 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 4C 24 ?? 51 8D 94 24 ?? ?? ?? ?? 
            52 FF 15 ?? ?? ?? ?? 83 F8 ?? 89 44 24 ?? 0F 84 91 03 00 00 8B 9C 24 ?? ?? ?? ?? F6 44 24 ?? ?? 0F 84 73 02 00 00 8D 4C 
            24 ?? B8 ?? ?? ?? ?? 90 66 8B 10 66 3B 11 75 1E 66 85 D2 74 15 66 8B 50 ?? 66 3B 51 ?? 75 0F 83 C0 ?? 83 C1 ?? 66 85 D2 
            75 DE 33 C0 EB 05 1B C0 83 D8 ?? 85 C0 0F 84 23 03 00 00 8D 4C 24 ?? B8 ?? ?? ?? ?? 8D 64 24 ?? 66 8B 10 66 3B 11 75 1E 
            66 85 D2 74 15 66 8B 50 ?? 66 3B 51 ?? 75 0F 83 C0 ?? 83 C1 ?? 66 85 D2 75 DE 33 C0 EB 05 1B C0 83 D8 ?? 85 C0 0F 84 E3 
            02 00 00 55 8D 84 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B C5 83 C4 ?? 8D 50 ?? 8B FF 66 8B 08 83 C0 ?? 66 85 
            C9 75 F5 2B C2 D1 F8 83 F8 ?? 76 1A 68 ?? ?? ?? ?? 8D 8C 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 8D 54 
            24 ?? 52 8D 84 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 8C 24 ?? ?? ?? ?? B8 ?? ?? ?? ?? 66 8B 10 66 
            3B 11 75 1E 66 85 D2 74 15 66 8B 50 ?? 66 3B 51 ?? 75 0F 83 C0 ?? 83 C1 ?? 66 85 D2 75 DE 33 C0 EB 05 1B C0 83 D8 ?? 85 
            C0 0F 84 3F 02 00 00 8D 8C 24 ?? ?? ?? ?? B8 ?? ?? ?? ?? 66 8B 10 66 3B 11 75 1E 66 85 D2 74 15 66 8B 50 ?? 66 3B 51 ?? 
            75 0F 83 C0 ?? 83 C1 ?? 66 85 D2 75 DE 33 C0 EB 05 1B C0 83 D8 ?? 85 C0 0F 84 00 02 00 00 8D 8C 24 ?? ?? ?? ?? B8
        }

        $file_search_0_3_5a_2 = { 
            66 8B 10 66 3B 11 75 1E 66 85 D2 74 15 66 8B 50 ?? 66 3B 51 ?? 75 0F 83 C0 ?? 83 C1 ?? 66 85 D2 75 DE 33 C0 EB 05 
            1B C0 83 D8 ?? 85 C0 0F 84 C1 01 00 00 8D 8C 24 ?? ?? ?? ?? B8 ?? ?? ?? ?? 66 8B 10 66 3B 11 75 1E 66 85 D2 74 15 66 8B 
            50 ?? 66 3B 51 ?? 75 0F 83 C0 ?? 83 C1 ?? 66 85 D2 75 DE 33 C0 EB 05 1B C0 83 D8 ?? 85 C0 0F 84 82 01 00 00 8D 8C 24 ?? 
            ?? ?? ?? B8 ?? ?? ?? ?? 66 8B 10 66 3B 11 75 1E 66 85 D2 74 15 66 8B 50 ?? 66 3B 51 ?? 75 0F 83 C0 ?? 83 C1 ?? 66 85 D2 
            75 DE 33 C0 EB 05 1B C0 83 D8 ?? 85 C0 0F 84 43 01 00 00 8D 8C 24 ?? ?? ?? ?? 53 51 E8 0F FD FF FF 8D 94 24 ?? ?? ?? ?? 
            52 8D 84 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 8D 8C 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 
            E8 ?? ?? ?? ?? 83 C4 ?? 8D 84 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 ED 00 00 00 55 8D 94 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 52 E8 
            ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 4C 24 ?? 51 8D 94 
            24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 85 DB 8D 44 24 ?? 0F 84 79 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 ?? 
            68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 0F 85 78 00 00 00 8D 4C 24 ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 
            50 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 59 8D 54 24 ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 
            85 C0 75 3A 8D 7C 24 ?? E8 ?? ?? ?? ?? 83 F8 ?? 75 2C 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 1E 68 ?? ?? ?? ?? 50 E8 ?? 
            ?? ?? ?? 83 C4 ?? 85 C0 74 0C 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7C 24 ?? 8D 4C 24 ?? 51 57 FF 15 ?? ?? ?? ?? 85 C0 
            0F 85 7D FC FF FF 57 FF 15 ?? ?? ?? ?? 8B 8C 24 ?? ?? ?? ?? 5F 5D 5B 33 CC E8 ?? ?? ?? ?? 81 C4 ?? ?? ?? ?? C3 
        }

        $encrypt_file_0_2_6a_1 = {
            B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C4 89 84 24 ?? ?? ?? ?? 33 C0 56 8B B4 24 ?? ?? ?? ?? 57 33 FF 68 ?? ?? 
            ?? ?? 89 84 24 ?? ?? ?? ?? 89 84 24 ?? ?? ?? ?? 89 84 24 ?? ?? ?? ?? 66 89 84 24 ?? ?? ?? ?? 88 84 24 ?? ?? ?? ?? 88 84 
            24 ?? ?? ?? ?? 89 84 24 ?? ?? ?? ?? 89 84 24 ?? ?? ?? ?? 89 84 24 ?? ?? ?? ?? 66 89 84 24 ?? ?? ?? ?? 88 84 24 ?? ?? ?? 
            ?? 8D 84 24 ?? ?? ?? ?? 57 50 89 74 24 ?? C6 84 24 ?? ?? ?? ?? ?? 89 7C 24 ?? 66 89 BC 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 
            ?? 56 8D 8C 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 8D 94 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 52 
            E8 ?? ?? ?? ?? 83 C4 ?? 57 68 ?? ?? ?? ?? 6A ?? 57 6A ?? 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 8B F0 83 FE ?? 74 1A 57 56 
            FF 15 ?? ?? ?? ?? 8B F8 83 FF ?? 89 7C 24 ?? 75 21 56 FF 15 ?? ?? ?? ?? 5F 83 C8 ?? 5E 8B 8C 24 ?? ?? ?? ?? 33 CC E8 ?? 
            ?? ?? ?? 81 C4 ?? ?? ?? ?? C3 81 FF ?? ?? ?? ?? 77 D7 53 55 8D 84 24 ?? ?? ?? ?? 6A ?? 50 E8 ?? ?? ?? ?? 8B 94 24 ?? ?? 
            ?? ?? 8B 8C 24 ?? ?? ?? ?? 8B 84 24 ?? ?? ?? ?? 89 94 24 ?? ?? ?? ?? 8B D7 83 E2 ?? BB ?? ?? ?? ?? 2B DA 89 8C 24
        }

        $encrypt_file_0_2_6a_2 = { 
            8B 8C 24 ?? ?? ?? ?? 03 FB 57 89 84 24 ?? ?? ?? ?? 89 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B E8 83 C4 ?? 85 ED 74 3C 
            8B 4C 24 ?? 6A ?? 8D 44 24 ?? 50 51 55 56 FF 15 ?? ?? ?? ?? 85 C0 74 24 8B 44 24 ?? 3B 44 24 ?? 75 1A 53 8D 14 28 53 52 
            E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 8B D8 83 C4 ?? 85 DB 75 0F 56 FF 15 ?? ?? ?? ?? 83 C8 ?? E9 D5 00 00 00 8D 44 24 ?? 50 
            68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 4C 24 ?? 51 8D 94 24 ?? ?? ?? ?? 52 57 53 55 E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 6A ?? 6A ?? 
            56 FF 15 ?? ?? ?? ?? 6A ?? 8D 44 24 ?? 50 6A ?? 8D 8C 24 ?? ?? ?? ?? 51 56 FF 15 ?? ?? ?? ?? 6A ?? 8D 54 24 ?? 52 6A ?? 
            8D 44 24 ?? 50 56 FF 15 ?? ?? ?? ?? 6A ?? 8D 4C 24 ?? 51 57 53 56 FF 15 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 8B 74 24 ?? 8D 
            94 24 ?? ?? ?? ?? 52 56 FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 74 0F 56 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 83 05 
            ?? ?? ?? ?? ?? B8 ?? ?? ?? ?? 55 11 05 ?? ?? ?? ?? 01 3D ?? ?? ?? ?? 11 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 
            83 C4 ?? B8 ?? ?? ?? ?? 8B 8C 24 ?? ?? ?? ?? 5D 5B 5F 5E 33 CC E8 ?? ?? ?? ?? 81 C4 ?? ?? ?? ?? C3 
        }

        $encrypt_file_0_3_1 = {
            53 8D 84 24 ?? ?? ?? ?? 6A ?? 50 E8 ?? ?? ?? ?? 8B 94 24 ?? ?? ?? ?? 8B 8C 24 ?? ?? ?? ?? 8B 84 24 ?? ?? ?? ?? 89 94 24 
            ?? ?? ?? ?? 8B D5 83 E2 ?? BF ?? ?? ?? ?? 2B FA 89 8C 24 ?? ?? ?? ?? 8B 8C 24 ?? ?? ?? ?? 8D 1C 2F 53 89 84 24 ?? ?? ?? 
            ?? 89 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 89 44 24 ?? 74 38 6A ?? 8D 4C 24 ?? 51 55 50 56 FF 15 ?? ?? ?? ?? 
            85 C0 74 24 3B 6C 24 ?? 75 1E 57 57 8B 7C 24 ?? 8D 14 2F 52 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 8B E8 83 C4 ?? 85 ED 75 0F 
            56 FF 15 ?? ?? ?? ?? 83 C8 ?? E9 0F 01 00 00 8D 44 24 ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 4C 24 ?? 51 8D 94 24 ?? ?? 
            ?? ?? 52 53 55 57 E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 6A ?? 6A ?? 56 FF 15 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 6A ?? 8D 44 24 ?? 50 
            6A ?? 8D 8C 24 ?? ?? ?? ?? 51 56 FF D7 6A ?? 8D 54 24 ?? 52 6A ?? 8D 44 24 ?? 50 56 FF D7 6A ?? 8D 4C 24 ?? 51 53 55 56 
            FF D7 56 FF 15 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 33 F6 8D 9B ?? ?? ?? ?? 8B 44 24 ?? 6A ?? 8D 94 24 ?? ?? ?? ?? 52 50 FF 15 
            ?? ?? ?? ?? 85 C0 75 27 FF 15 ?? ?? ?? ?? 3D ?? ?? ?? ?? 75 0E 8D 8C 24 ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 6A ?? FF D7 83 
            C6 ?? 83 FE ?? 7C C0 A1 ?? ?? ?? ?? 33 F6 3B C6 74 13 8B 54 24 ?? 52 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 83 05 ?? 
            ?? ?? ?? ?? 8B 44 24 ?? 50 11 35 ?? ?? ?? ?? 01 1D ?? ?? ?? ?? 11 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 83 C4 
            ?? B8 ?? ?? ?? ?? 8B 8C 24 ?? ?? ?? ?? 5B 5D 5F 5E 33 CC E8 ?? ?? ?? ?? 81 C4 ?? ?? ?? ?? C3 
        }

        $encrypt_file_0_3_3_1 = {
            55 8D 84 24 ?? ?? ?? ?? 6A ?? 50 E8 ?? ?? ?? ?? 8B 94 24 ?? ?? ?? ?? 8B 84 24 ?? ?? ?? ?? 8B 8C 24 ?? ?? ?? ?? 89 94 24 
            ?? ?? ?? ?? 8B D3 83 E2 ?? BD ?? ?? ?? ?? 2B EA 89 84 24 ?? ?? ?? ?? 8D 04 2B 89 8C 24 ?? ?? ?? ?? 8B 8C 24 ?? ?? ?? ?? 
            50 89 8C 24 ?? ?? ?? ?? 89 44 24 ?? E8 ?? ?? ?? ?? 8B F8 83 C4 ?? 85 FF 0F 84 0A 01 00 00 6A ?? 8D 44 24 ?? 50 53 57 56 
            FF 15 ?? ?? ?? ?? 85 C0 75 18 56 FF 15 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? 83 C8 ?? E9 98 01 00 00 3B 5C 24 ?? 75 1E 
            55 8D 0C 1F 55 51 E8 ?? ?? ?? ?? 8B 6C 24 ?? 55 E8 ?? ?? ?? ?? 8B D8 83 C4 ?? 85 DB 75 18 57 E8 ?? ?? ?? ?? 83 C4 ?? 56 
            FF 15 ?? ?? ?? ?? 83 C8 ?? E9 5C 01 00 00 8D 54 24 ?? 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 44 24 ?? 50 8D 8C 24 ?? ?? ?? 
            ?? 51 55 53 57 E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 6A ?? 6A ?? 56 FF 15 ?? ?? ?? ?? 8B 2D ?? ?? ?? ?? 6A ?? 8D 54 24 ?? 52 6A 
            ?? 8D 84 24 ?? ?? ?? ?? 50 56 C7 44 24 ?? ?? ?? ?? ?? FF D5 85 C0 74 39 6A ?? 8D 4C 24 ?? 51 6A ?? 8D 54 24 ?? 52 56 C7 
            44 24 ?? ?? ?? ?? ?? FF D5 85 C0 74 1C 8B 4C 24 ?? 6A ?? 8D 44 24 ?? 50 51 53 56 C7 44 24 ?? ?? ?? ?? ?? FF D5 85 C0 75 
            1E 57 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 83 C4 ?? 56 FF 15 ?? ?? ?? ?? 83 C8 ?? E9 AB 00 00 00 56 FF 15 ?? ?? ?? ?? 56 FF
        }

        $encrypt_file_0_3_3_2 = { 
            15 ?? ?? ?? ?? 8B 2D ?? ?? ?? ?? 33 F6 8D 49 ?? 8B 44 24 ?? 6A ?? 8D 94 24 ?? ?? ?? ?? 52 50 FF 15 ?? ?? ?? ?? 85 C0 75 
            2A FF 15 ?? ?? ?? ?? 3D ?? ?? ?? ?? 75 0E 8D 8C 24 ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF D5 83 C6 ?? 83 FE 
            ?? 7C BD A1 ?? ?? ?? ?? 33 F6 3B C6 74 13 8B 54 24 ?? 52 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 83 05 ?? ?? ?? ?? ?? 
            8B 44 24 ?? 57 11 35 ?? ?? ?? ?? 01 05 ?? ?? ?? ?? 11 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 83 C4 ?? B8 ?? ?? 
            ?? ?? 8B 8C 24 ?? ?? ?? ?? 5D 5B 5F 5E 33 CC E8 ?? ?? ?? ?? 81 C4 ?? ?? ?? ?? C3 
        }

        $encrypt_file_0_3_4a_1 = {
            B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C4 89 84 24 ?? ?? ?? ?? 33 C0 56 8B B4 24 ?? ?? ?? ?? 57 33 FF 68 ?? ?? 
            ?? ?? 89 84 24 ?? ?? ?? ?? 89 84 24 ?? ?? ?? ?? 89 84 24 ?? ?? ?? ?? 66 89 84 24 ?? ?? ?? ?? 88 84 24 ?? ?? ?? ?? 88 84 
            24 ?? ?? ?? ?? 89 84 24 ?? ?? ?? ?? 89 84 24 ?? ?? ?? ?? 89 84 24 ?? ?? ?? ?? 66 89 84 24 ?? ?? ?? ?? 88 84 24 ?? ?? ?? 
            ?? 8D 84 24 ?? ?? ?? ?? 57 50 89 74 24 ?? C6 84 24 ?? ?? ?? ?? ?? 89 7C 24 ?? 66 89 BC 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 
            ?? 56 8D 8C 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 8D 94 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 52 
            E8 ?? ?? ?? ?? 83 C4 ?? 57 68 ?? ?? ?? ?? 6A ?? 57 57 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 8B F0 83 FE ?? 75 19 5F 0B C0 
            5E 8B 8C 24 ?? ?? ?? ?? 33 CC E8 ?? ?? ?? ?? 81 C4 ?? ?? ?? ?? C3 53 57 56 FF 15 ?? ?? ?? ?? 8B D8 83 FB ?? 74 08 81 FB 
            ?? ?? ?? ?? 76 22 56 FF 15 ?? ?? ?? ?? 5B 5F 83 C8 ?? 5E 8B 8C 24 ?? ?? ?? ?? 33 CC E8 ?? ?? ?? ?? 81 C4 ?? ?? ?? ?? C3 
            55 8D 84 24 ?? ?? ?? ?? 6A ?? 50 E8 ?? ?? ?? ?? 6A ?? 8D 8C 24 ?? ?? ?? ?? 51 8D 94 24 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 8B 
            C3 83 E0 ?? BD ?? ?? ?? ?? 2B E8 8D 04 2B 50 89 44 24 ?? E8 ?? ?? ?? ?? 8B F8 83 C4 ?? 85 FF 0F 84 0A 01 00 00 6A ?? 8D 
            4C 24 ?? 51 53 57 56 FF 15 ?? ?? ?? ?? 85 C0 75 18 56 FF 15 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? 83 C8 ?? E9 99 01 00
        }

        $encrypt_file_0_3_4a_2 = { 
            00 3B 5C 24 ?? 75 1E 55 8D 14 1F 55 52 E8 ?? ?? ?? ?? 8B 6C 24 ?? 55 E8 ?? ?? ?? ?? 8B D8 83 C4 ?? 85 DB 75 18 57 E8 ?? 
            ?? ?? ?? 83 C4 ?? 56 FF 15 ?? ?? ?? ?? 83 C8 ?? E9 5D 01 00 00 8D 44 24 ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 4C 24 ?? 
            51 8D 94 24 ?? ?? ?? ?? 52 55 53 57 E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 6A ?? 6A ?? 56 FF 15 ?? ?? ?? ?? 8B 2D ?? ?? ?? ?? 6A 
            ?? 8D 44 24 ?? 50 6A ?? 8D 8C 24 ?? ?? ?? ?? 51 56 C7 44 24 ?? ?? ?? ?? ?? FF D5 85 C0 74 39 6A ?? 8D 54 24 ?? 52 6A ?? 
            8D 44 24 ?? 50 56 C7 44 24 ?? ?? ?? ?? ?? FF D5 85 C0 74 1C 8B 54 24 ?? 6A ?? 8D 4C 24 ?? 51 52 53 56 C7 44 24 ?? ?? ?? 
            ?? ?? FF D5 85 C0 75 1E 57 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 83 C4 ?? 56 FF 15 ?? ?? ?? ?? 83 C8 ?? E9 AC 00 00 00 56 FF 
            15 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 8B 2D ?? ?? ?? ?? 33 F6 8D 64 24 ?? 8B 4C 24 ?? 6A ?? 8D 84 24 ?? ?? ?? ?? 50 51 FF 
            15 ?? ?? ?? ?? 85 C0 75 2A FF 15 ?? ?? ?? ?? 3D ?? ?? ?? ?? 75 0E 8D 94 24 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? 
            ?? FF D5 83 C6 ?? 83 FE ?? 7C BD A1 ?? ?? ?? ?? 33 F6 3B C6 74 13 8B 4C 24 ?? 51 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 
            ?? 83 05 ?? ?? ?? ?? ?? 8B 54 24 ?? 57 11 35 ?? ?? ?? ?? 01 15 ?? ?? ?? ?? 11 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 53 E8 ?? ?? 
            ?? ?? 83 C4 ?? B8 ?? ?? ?? ?? 8B 8C 24 ?? ?? ?? ?? 5D 5B 5F 5E 33 CC E8 ?? ?? ?? ?? 81 C4 ?? ?? ?? ?? C3
        }

        $encrypt_file_0_3_5a_1 = {
            B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C4 89 84 24 ?? ?? ?? ?? 53 33 C0 55 56 57 33 FF 68 ?? ?? ?? ?? 89 84 24 
            ?? ?? ?? ?? 89 84 24 ?? ?? ?? ?? 89 84 24 ?? ?? ?? ?? 66 89 84 24 ?? ?? ?? ?? 88 84 24 ?? ?? ?? ?? 88 84 24 ?? ?? ?? ?? 
            89 84 24 ?? ?? ?? ?? 89 84 24 ?? ?? ?? ?? 89 84 24 ?? ?? ?? ?? 66 89 84 24 ?? ?? ?? ?? 88 84 24 ?? ?? ?? ?? 8D 84 24 ?? 
            ?? ?? ?? 8B F1 57 50 89 74 24 ?? C6 84 24 ?? ?? ?? ?? ?? 89 7C 24 ?? 66 89 BC 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 6A 
            ?? 56 8D 8C 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 8D 94 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 52 
            E8 ?? ?? ?? ?? 83 C4 ?? 57 68 ?? ?? ?? ?? 6A ?? 57 57 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 8B F0 83 FE ?? 0F 84 D2 00 00 
            00 57 56 FF 15 ?? ?? ?? ?? 8B E8 83 FD ?? 0F 84 B8 00 00 00 3B EF 0F 84 B0 00 00 00 81 FD ?? ?? ?? ?? 0F 87 A4 00 00 00 
            8D 4F ?? 8D 94 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 8C 24 ?? ?? ?? ?? 8B 84 24 ?? ?? ?? ?? 8B 94 24 ?? ?? ?? ?? 89 8C 24 ?? 
            ?? ?? ?? 89 84 24 ?? ?? ?? ?? 8B 84 24 ?? ?? ?? ?? 8B CD 83 E1 ?? BB ?? ?? ?? ?? 2B D9 89 84 24 ?? ?? ?? ?? 8D 04 2B 50 
            89 94 24 ?? ?? ?? ?? 89 44 24 ?? E8 ?? ?? ?? ?? 8B F8 83 C4 ?? 85 FF 74 3B 6A ?? 8D 54 24 ?? 52 55 57 56 FF 15 ?? ?? ?? 
            ?? 85 C0 75 18 56 FF 15 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? 83 C8 ?? E9 98 01 00 00 3B 6C 24 ?? 74 18 57 E8
        }

        $encrypt_file_0_3_5a_2 = { 
            83 C4 ?? 56 FF 15 ?? ?? ?? ?? 83 C8 ?? E9 7A 01 00 00 53 8D 04 2F 53 50 E8 ?? ?? ?? ?? 8B 6C 24 ?? 83 C4 ?? 55 E8 ?? 
            ?? ?? ?? 8B D8 83 C4 ?? 85 DB 74 C7 8D 4C 24 ?? 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 54 24 ?? 52 8D 84 24 ?? ?? ?? ?? 50 
            55 57 8B CB E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 6A ?? 6A ?? 56 FF 15 ?? ?? ?? ?? 8B 2D ?? ?? ?? ?? 6A ?? 8D 4C 24 ?? 51 6A ?? 
            8D 94 24 ?? ?? ?? ?? 52 56 C7 44 24 ?? ?? ?? ?? ?? FF D5 85 C0 75 0F 57 E8 ?? ?? ?? ?? 83 C4 ?? 53 E9 5E FF FF FF 6A ?? 
            8D 44 24 ?? 50 6A ?? 8D 4C 24 ?? 51 56 C7 44 24 ?? ?? ?? ?? ?? FF D5 85 C0 74 D4 8B 44 24 ?? 6A ?? 8D 54 24 ?? 52 50 53 
            56 C7 44 24 ?? ?? ?? ?? ?? FF D5 85 C0 74 B8 56 FF 15 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 8B 2D ?? ?? ?? ?? 33 F6 EB 09 8D 
            A4 24 ?? ?? ?? ?? 8B FF 8B 54 24 ?? 6A ?? 8D 8C 24 ?? ?? ?? ?? 51 52 FF 15 ?? ?? ?? ?? 85 C0 75 2A FF 15 ?? ?? ?? ?? 3D 
            ?? ?? ?? ?? 75 0E 8D 84 24 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF D5 83 C6 ?? 83 FE ?? 7C BD A1 ?? ?? ?? ?? 
            33 F6 3B C6 74 13 8B 4C 24 ?? 51 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 83 05 ?? ?? ?? ?? ?? 8B 54 24 ?? 57 11 35 ?? 
            ?? ?? ?? 01 15 ?? ?? ?? ?? 11 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 53 E8 ?? ?? ?? ?? 83 C4 ?? B8 ?? ?? ?? ?? 8B 8C 24 
            ?? ?? ?? ?? 5F 5E 5D 5B 33 CC E8 ?? ?? ?? ?? 81 C4 ?? ?? ?? ?? C3 
        }

        $server_communication_0_2_6a_1 = {
            B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C4 89 84 24 ?? ?? ?? ?? 8B 84 24 ?? ?? ?? ?? 8B 00 53 33 DB 39 1D ?? ?? 
            ?? ?? A3 ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 83 F8 ?? 0F 87 ?? ?? ?? ?? 55 56 57 68 ?? ?? ?? ?? 8D 44 24 ?? 53 50 88 5C 24 ?? 
            E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8C 24 ?? ?? ?? ?? 53 51 88 9C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 53 89 44 24 ?? 89 44 
            24 ?? 89 44 24 ?? E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 83 C4 ?? 51 8B 0D ?? ?? ?? ?? 51 8B 0D ?? ?? ?? ?? 51 8B 0D ?? ?? ?? 
            ?? 51 52 8B 15 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? 68 ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 52 50 E8 ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 52 
            50 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 52 8B 15 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? 51 52 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 
            ?? 50 68 ?? ?? ?? ?? 8D 4C 24 ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 8D 44 24 ?? 83 C4 ?? 8D 70 ?? 8A 08 83 C0 ?? 3A CB 75 
            F7 8D 54 24 ?? 52 8D 8C 24 ?? ?? ?? ?? 51 2B C6 50 8D 54 24 ?? 52 E8 ?? ?? ?? ?? 8D 4C 24 ?? 51 8D 94 04 ?? ?? ?? ?? 52 
            E8 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8D 4C 24 ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 83 
            C4 ?? 53 53 53 53 52 FF 15 ?? ?? ?? ?? 8B F8 A1 ?? ?? ?? ?? 8B 0C 85 ?? ?? ?? ?? 8B 14 85 ?? ?? ?? ?? 51 53 52 FF 15
        }

        $server_communication_0_2_6a_2 = { 
            A1 ?? ?? ?? ?? 8B 0C 85 ?? ?? ?? ?? 53 53 6A ?? 53 53 68 ?? ?? ?? ?? 51 57 FF 15 ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 
            53 53 53 8D 54 24 ?? 52 8B E8 68 ?? ?? ?? ?? 55 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B F0 8D 84 24 ?? ?? ?? ?? 53 50 88 9C 
            24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 53 53 53 53 56 89 5C 24 ?? FF 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? 
            ?? ?? 8D 4C 24 ?? 51 68 ?? ?? ?? ?? 8D 94 24 ?? ?? ?? ?? 52 56 FF 15 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 
            E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 0F 84 ?? ?? ?? ?? 33 C0 68 ?? ?? ?? ?? 8D 4C 24 ?? 68 ?? ?? ?? ?? 51 C7 05 ?? ?? ?? ?? ?? 
            ?? ?? ?? 89 5C 24 ?? A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? A3 ?? ?? 
            ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 54 24 ?? 52 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 50 E8 
            ?? ?? ?? ?? 83 C4 ?? 56 8B 35 ?? ?? ?? ?? FF D6
        }

        $server_communication_0_3_1_1 = {
            8B 0D ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 51 8B 0D ?? ?? ?? ?? 51 8B 0D ?? ?? ?? ?? 51 8B 0D ?? ?? ?? ?? 51 8B 0D ?? ?? 
            ?? ?? 51 8B 0D ?? ?? ?? ?? 51 52 8B 15 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? 68 ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 52 50 E8 ?? ?? ?? 
            ?? 53 68 ?? ?? ?? ?? 52 50 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 52 8B 15 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? 51 52 68 ?? ?? ?? ?? 
            50 E8 ?? ?? ?? ?? 83 C4 ?? 50 68 ?? ?? ?? ?? 8D 4C 24 ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 8D 44 24 ?? 83 C4 ?? 8D 48 ?? 
            8A 10 83 C0 ?? 3A D3 75 F7 55 56 57 2B C1 8D 54 24 ?? 52 8D 8C 24 ?? ?? ?? ?? 51 50 8D 54 24 ?? 52 E8 ?? ?? ?? ?? 8D 4C 
            24 ?? 51 8D 94 04 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8D 4C 24 ?? 68 ?? ?? ?? ?? 51 E8 
            ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 83 C4 ?? 53 53 53 53 52 FF 15 ?? ?? ?? ?? 8B F8 A1 ?? ?? ?? ?? 8B 0C 85 ?? ?? ?? ?? 8B 14 
            85 ?? ?? ?? ?? 51 53 52 FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 F8 ?? 53 53 6A ?? 53 53 73 23 8B 04 85 ?? ?? ?? ?? 6A ?? 50 
            57 FF 15 ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 53 53 53 8D 4C 24 ?? 8B F0 51 EB 24 8B 14 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 52 57 FF 
            15 ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 53 53 8B F0 53 8D 44 24 ?? 50 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8C
        }

        $server_communication_0_3_1_2 = { 
            24 ?? ?? ?? ?? 53 51 8B E8 88 9C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 53 53 53 53 55 89 5C 24 ?? FF 15 ?? ?? ?? ?? FF 
            15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 8D 54 24 ?? 52 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 55 FF 15 ?? ?? ?? ?? 8D 8C 
            24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 0F 84 ?? ?? ?? ?? 33 C0 68 ?? ?? ?? ?? 8D 54 24 ?? 68 ?? 
            ?? ?? ?? 52 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 89 5C 24 ?? A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? A3 ?? 
            ?? ?? ?? A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 50 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 8B 4C 24 ?? 51 E8 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 83 C4 ?? 55 FF D3 
        }

        $server_communication_0_3_3_1 = {
            B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C4 89 84 24 ?? ?? ?? ?? B8 ?? ?? ?? ?? 8D 50 ?? 8A 08 83 C0 ?? 84 C9 75 
            F7 2B C2 75 0D 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 53 55 56 57 68 ?? ?? ?? ?? 8D 44 24 ?? 6A ?? 50 C6 44 24 ?? ?? E8 
            ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8C 24 ?? ?? ?? ?? 6A ?? 51 C6 84 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 33 C0 
            83 C4 ?? 50 50 50 50 52 89 44 24 ?? 89 44 24 ?? 89 44 24 ?? FF 15 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 8B F8 89 7C 24 ?? 33 F6 
            EB 04 8B 7C 24 ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 6A ?? 50 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8C 24 ?? ?? ?? ?? 6A ?? 51 E8 ?? 
            ?? ?? ?? 6A ?? E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 51 8B 0D ?? ?? ?? ?? 51 8B 0D ?? ?? ?? ?? 56 51 
            8B 0D ?? ?? ?? ?? 51 8B 0D ?? ?? ?? ?? 51 52 8B 15 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 52 
            50 E8 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 52 50 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 52 8B 15 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? 51 
            52 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4C 24 ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? 
            ?? 8D 44 24 ?? 83 C4 ?? 8D 48 ?? 8A 10 83 C0 ?? 84 D2 75 F7 2B C1 8D 54 24 ?? 52 8D 8C 24 ?? ?? ?? ?? 51 50 8D 54 24 
        }

        $server_communication_0_3_3_2 = { 
            52 E8 ?? ?? ?? ?? 8D 4C 24 ?? 51 8D 94 04 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8D 4C 24 
            ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 83 FE ?? 6A ?? 6A ?? 6A ?? 6A ?? 6A ?? 7D 23 8B 14 B5 ?? ?? ?? ?? 6A ?? 52 
            57 FF D3 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 8B F8 6A ?? 8D 44 24 ?? 50 EB 3C 8B 0C B5 ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 57 FF 
            D3 8B 14 B5 ?? ?? ?? ?? 52 8B F8 8B 04 B5 ?? ?? ?? ?? 6A ?? 50 FF 15 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 
            8D 4C 24 ?? 51 68 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 94 24 ?? ?? ?? ?? 6A ?? 52 8B E8 C6 84 24 ?? ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 6A ?? 6A ?? 6A ?? 55 C7 44 24 ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 
            C0 75 32 8D 44 24 ?? 50 68 ?? ?? ?? ?? 8D 8C 24 ?? ?? ?? ?? 51 55 FF 15 ?? ?? ?? ?? 8D 94 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 
            52 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 55 8B 2D ?? ?? ?? ?? FF D5 
        }

        $server_communication_0_3_4a_1 = {
            B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C4 89 84 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 6A ?? 50 C6 44 24 ?? 
            ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8C 24 ?? ?? ?? ?? 6A ?? 51 C6 84 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 83 C4 ?? 85 C0 75 0D 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 53 55 56 57 6A ?? 8D 54 24 ?? 6A ?? 52 E8 ?? ?? 
            ?? ?? A1 ?? ?? ?? ?? 83 C4 ?? 6A ?? 6A ?? 6A ?? 6A ?? 50 FF 15 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 8B F8 89 7C 24 ?? 33 F6 EB 
            04 8B 7C 24 ?? 68 ?? ?? ?? ?? 8D 4C 24 ?? 6A ?? 51 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 94 24 ?? ?? ?? ?? 6A ?? 52 E8 ?? ?? 
            ?? ?? 6A ?? E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 83 C4 ?? 51 8B 0D ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 8B 0D ?? ?? ?? ?? 51 8B 0D 
            ?? ?? ?? ?? 56 51 8B 0D ?? ?? ?? ?? 51 8B 0D ?? ?? ?? ?? 51 52 8B 15 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 
            68 ?? ?? ?? ?? 52 50 E8 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 52 50 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 52 8B 15 ?? ?? ?? ?? 50 
            A1 ?? ?? ?? ?? 51 52 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4C 24 
            ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 8D 54 24 ?? 52 8D 84 24 ?? ?? ?? ?? 50 8D 4C 24 ?? 51 E8 ?? ?? ?? ?? 83 C4 
            ?? 50 8D 54 24 ?? 52 E8 ?? ?? ?? ?? 8D 4C 24 ?? 51 8D 94 04 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 68
        }

        $server_communication_0_3_4a_2 = { 
            8D 4C 24 ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 83 FE ?? 6A ?? 6A ?? 6A ?? 6A ?? 6A ?? 7D 23 8B 14 B5 ?? 
            ?? ?? ?? 6A ?? 52 57 FF D3 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 8B F8 6A ?? 8D 44 24 ?? 50 EB 3C 8B 0C B5 ?? ?? ?? ?? 68 ?? 
            ?? ?? ?? 51 57 FF D3 8B 14 B5 ?? ?? ?? ?? 52 8B F8 8B 04 B5 ?? ?? ?? ?? 6A ?? 50 FF 15 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 
            6A ?? 6A ?? 6A ?? 8D 4C 24 ?? 51 68 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 94 24 ?? ?? ?? ?? 6A ?? 52 8B E8 
            C6 84 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 6A ?? 6A ?? 6A ?? 55 C7 44 24 ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF 
            15 ?? ?? ?? ?? 85 C0 75 32 8D 44 24 ?? 50 68 ?? ?? ?? ?? 8D 8C 24 ?? ?? ?? ?? 51 55 FF 15 ?? ?? ?? ?? 8D 94 24 ?? ?? ?? 
            ?? 68 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 18 55 8B 2D ?? ?? ?? ?? FF D5 57 FF D5 83 C6 ?? 83 FE ?? 0F 8C CE 
            FD FF FF 8B 44 24 ?? 50 FF 15
        }

        $server_communication_0_3_5a_1 = {
            55 8B EC 83 E4 ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C4 89 84 24 ?? ?? ?? ?? 53 56 57 68 ?? ?? ?? ?? 8D 44 
            24 ?? 6A ?? 50 C6 44 24 ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8C 24 ?? ?? ?? ?? 6A ?? 51 C6 84 24 ?? ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? B8 ?? ?? ?? ?? 83 C4 ?? 8D 50 ?? 8B FF 8A 08 83 C0 ?? 84 C9 75 F7 2B C2 75 05 E8 ?? ?? ?? ?? 33 C0 50 50 50 50 
            68 ?? ?? ?? ?? 89 44 24 ?? 89 44 24 ?? 89 44 24 ?? FF 15 ?? ?? ?? ?? 89 44 24 ?? 33 DB 68 ?? ?? ?? ?? 8D 54 24 ?? 6A ?? 
            52 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 6A ?? 50 E8 ?? ?? ?? ?? 6A ?? E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 83 
            C4 ?? 51 8B 0D ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 8B 0D ?? ?? ?? ?? 51 8B 0D ?? ?? ?? ?? 53 51 8B 0D ?? ?? ?? ?? 51 8B 0D ?? 
            ?? ?? ?? 51 52 8B 15 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 52 50 E8 ?? ?? ?? ?? 6A ?? 68 ?? 
            ?? ?? ?? 52 50 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 52 8B 15 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? 51 52 68 ?? ?? ?? ?? 68 ?? ?? ?? 
            ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 50 68 ?? ?? ?? ?? 8D 4C 24 ?? 68 ?? ?? ?? ?? 51 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 44 24 ?? 
            83 C4 ?? 8D 70 ?? 8B FF 8A 08 83 C0 ?? 84 C9 75 F7 8D 94 24 ?? ?? ?? ?? 2B C6 52 8D 7C 24 ?? 8D 4C 24 ?? E8 ?? ?? ?? ?? 
            8D 8C 04 ?? ?? ?? ?? 8B F7 E8 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 8D 4C 24 ?? 68 ?? ?? ?? ?? 51 B8 ?? ?? ?? ?? E8
        }

        $server_communication_0_3_5a_2 = { 
            8B 14 9D ?? ?? ?? ?? 8B 44 24 ?? 83 C4 ?? 83 FB ?? 6A ?? 6A ?? 6A ?? 6A ?? 6A ?? 7D 20 6A ?? 52 50 FF 15 ?? ?? ?? 
            ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 8D 4C 24 ?? 8B F0 51 EB 39 68 ?? ?? ?? ?? 52 50 FF 15 ?? ?? ?? ?? 8B 0C 9D ?? 
            ?? ?? ?? 8B 14 9D ?? ?? ?? ?? 51 6A ?? 52 8B F0 FF 15 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 8D 44 24 ?? 50 
            68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8C 24 ?? ?? ?? ?? 6A ?? 51 8B F8 C6 84 24 ?? ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 83 C4 ?? 6A ?? 6A ?? 6A ?? 6A ?? 57 C7 44 24 ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 32 8D 54 
            24 ?? 52 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 57 FF 15 ?? ?? ?? ?? 8D 8C 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? 
            ?? 83 C4 ?? 85 C0 75 18 57 8B 3D ?? ?? ?? ?? FF D7 56 FF D7 83 C3 ?? 83 FB ?? 0F 8C CD FD FF FF 8B 54 24 ?? 52 FF 15
        }

        $server_communication_2_0_4e = {
            B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C4 89 84 24 ?? ?? ?? ?? 83 3D ?? ?? 
            ?? ?? ?? 53 56 57 75 ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? EB ?? A1 ?? 
            ?? ?? ?? 50 C7 44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 89 44 24 ?? B8 ?? ?? ?? 
            ?? 8D 50 ?? 33 DB 8A 08 40 3A CB 75 ?? 2B C2 75 ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 
            8C 24 ?? ?? ?? ?? 53 51 88 9C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 53 53 53 53 68 
            ?? ?? ?? ?? FF 15 
        }

        $search_and_encrypt_2_0_4e_1 = {
            55 8B EC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 53 8B 5D ?? 56 
            57 33 C0 68 ?? ?? ?? ?? 50 8D 8D ?? ?? ?? ?? 51 66 89 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            83 C4 ?? 33 D2 68 ?? ?? ?? ?? 52 8D 85 ?? ?? ?? ?? 50 66 89 95 ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 83 C4 ?? 53 8D 8D ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? 
            ?? ?? ?? 8D 95 ?? ?? ?? ?? 68 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 8D 85 ?? ?? ?? 
            ?? 50 8D 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 8B F0 89 B5 ?? ?? ?? ?? 83 FE ?? 0F 84  
        }

        $search_and_encrypt_2_0_4e_2 = {
            0F 84 ?? ?? ?? ?? F6 85 ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? B8 ?? ?? 
            ?? ?? 66 8B 10 66 3B 11 75 ?? 66 85 D2 74 ?? 66 8B 50 ?? 66 3B 51 ?? 75 ?? 83 C0 ?? 
            83 C1 ?? 66 85 D2 75 ?? 33 C0 EB ?? 1B C0 83 D8 ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 8D ?? 
            ?? ?? ?? B8 ?? ?? ?? ?? 66 8B 10 66 3B 11 75 ?? 66 85 D2 74 ?? 66 8B 50 ?? 66 3B 51 
            ?? 75 ?? 83 C0 ?? 83 C1 ?? 66 85 D2 75 ?? 33 C0 EB ?? 1B C0 83 D8 ?? 85 C0 0F 84 ?? 
            ?? ?? ?? 53 8D 95 ?? ?? ?? ?? 68 ?? ?? ?? ?? 52 E8 
        }

        $search_and_encrypt_2_0_4e_3 = {
            8B C3 83 C4 ?? 8D 50 ?? 90 66 8B 08 83 C0 ?? 66 85 C9 75 ?? 2B C2 D1 F8 83 F8 ?? 76 
            ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 8D 
            ?? ?? ?? ?? 51 8D 95 ?? ?? ?? ?? 68 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 8D 8D ?? 
            ?? ?? ?? B8 ?? ?? ?? ?? 66 8B 10 66 3B 11 75 ?? 66 85 D2 74 ?? 66 8B 50 ?? 66 3B 51 
            ?? 75 ?? 83 C0 ?? 83 C1 ?? 66 85 D2 75 ?? 33 C0 EB ?? 1B C0 83 D8 ?? 85 C0 0F 84 
        }

        $search_and_encrypt_2_0_4e_4 = {
            8D 8D ?? ?? ?? ?? B8 ?? ?? ?? ?? 66 8B 10 66 3B 11 75 ?? 66 85 D2 74 ?? 66 8B 50 ?? 
            66 3B 51 ?? 75 ?? 83 C0 ?? 83 C1 ?? 66 85 D2 75 ?? 33 C0 EB ?? 1B C0 83 D8 ?? 85 C0 
            0F 84 ?? ?? ?? ?? 8B 45 ?? 50 8D 8D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 
            52 8D 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 8D ?? ?? ?? ?? E8 
            ?? ?? ?? ?? E9 ?? ?? ?? ?? 53 8D 8D ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 
            C4 ?? 68 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 68 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 8D 
            85 ?? ?? ?? ?? 50 8D 8D ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 E8 
        }

        $search_and_encrypt_2_0_4e_5 = {
            8D 85 ?? ?? ?? ?? 83 C4 ?? 8D 50 ?? 66 8B 08 83 C0 ?? 66 85 C9 75 ?? 2B C2 8D 95 ?? 
            ?? ?? ?? D1 F8 52 8D 78 ?? E8 ?? ?? ?? ?? 83 C4 ?? 8B F0 57 56 E8 ?? ?? ?? ?? 8B 3D 
            ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 FF D7 83 C4 ?? 85 C0 75 ?? 68 ?? ?? ?? ?? 56 FF D7 83 
            C4 ?? 85 C0 75 ?? 68 ?? ?? ?? ?? 56 FF D7 83 C4 ?? 85 C0 75 ?? 8B C6 E8 ?? ?? ?? ?? 
            83 F8 ?? 75 ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 8B B5 ?? ?? ?? ?? 
            83 C4 ?? 8D 85 ?? ?? ?? ?? 50 56 FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 56 FF 15  
        }

        $server_communication_4_0_1 = {
            55 8B EC 83 E4 ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C4 89 84 24 
        }

        $server_communication_4_0_2 = {
            8A 08 40 3A CB 75 ?? 2B ?? 50 8D ?? ?? ?? ?? ?? ?? [0-2] E8 ?? ?? ?? ?? 83 C4 04 8D
            ?? 24 ?? ?? ?? ?? ?? (8B ??|8D ?? 24 ?? ?? ?? ??) ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ??
            C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ??
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 83 C4 08 8D ?? 01 [0-7] 8A 08 40 3A CB 
            75 ?? 2B ?? 8B C8 8D 51 ?? 83 E2 ?? B8 ?? ?? ?? ?? 2B C2 50 50 8D 7C 01 ?? 8D 84 0C 
            ?? ?? ?? ?? 50 E8 
        }

        $server_communication_4_0_3 = {
            83 C4 ?? 8D 8C 24 ?? ?? ?? ?? 51 8D 94 24 ?? ?? ?? ?? 52 8D 84 24 ?? ?? ?? ?? ?? [1-2]
            8D ?? 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8C 24 ?? ?? ?? ?? [0-3] 51 E8 ?? ?? ?? ?? 
            8B 15 ?? ?? ?? ?? 83 C4 ?? 8B ?? 8B 42 ?? ?? 50 8D 8C 24 ?? ?? ?? ?? 51 BA ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 83 C4 ?? ?? E8 ?? ?? ?? ?? 8B 54 24 ?? 83 C4 ?? 52 E8 ?? ?? ?? ?? 83 C4 
            ?? 33 ?? 89 ?? 24 ?? 6A ?? 8D 44 24 ?? 53 50 E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? B8 
            ?? ?? ?? ?? 8D 8C 24 ?? ?? ?? ?? 53 51 C7 44 24 ?? ?? ?? ?? ?? 89 44 24 ?? 89 84 24 ?? 
            ?? ?? ?? 88 9C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 8D 94 24 ?? ?? ?? 
            ?? 53 52 88 9C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B ?? ?? ?? 8B ?? 83 C4 ?? 8D 50 
        }

        $file_search_4_0_1 = {
            55 8B EC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 56 57 33 C0 68 
            ?? ?? ?? ?? 50 8D 8D ?? ?? ?? ?? 51 66 89 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 D2 68 ?? 
            ?? ?? ?? 52 8D 85 ?? ?? ?? ?? 50 66 89 95 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? 
            ?? 6A ?? 51 E8
        }

        $file_search_4_0_2 = {
            74 ?? FF 15 ?? ?? ?? ?? 50 8D 95 ?? ?? ?? ?? 52 EB ?? FF 15 ?? ?? ?? ?? 50 68 ?? ?? 
            ?? ?? A1 ?? ?? ?? ?? 8B 48 ?? 51 8D 95 ?? ?? ?? ?? 52 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            83 C4 ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 6A ?? 6A ?? 6A ?? 
            6A ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 FF D0 8B F0 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 
            64 A1 ?? ?? ?? ?? 3E 8B 40 ?? 89 85 ?? ?? ?? ?? 8B BD ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 
            ?? 6A ?? E8 ?? ?? ?? ?? 83 C4 ?? 56 FF D0 83 FF ?? 0F 85 ?? ?? ?? ?? 83 3D ?? ?? ?? 
            ?? ?? 74 ?? 8B 0D ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 8B 51 ?? 8D 85 ?? ?? ?? ?? 50 52 
            8D 85 ?? ?? ?? ?? 50 EB ?? 8B 15 ?? ?? ?? ?? 8B 42 ?? 8D 8D ?? ?? ?? ?? 51 68 ?? ?? 
            ?? ?? 50 8D 8D 
        }

        $file_search_4_0_3 = {
            E8 ?? ?? ?? ?? 83 C4 ?? 8D 8D ?? ?? ?? ?? 51 8D 95 ?? ?? ?? ?? 52 6A ?? 6A ?? 6A ?? 
            6A ?? 6A ?? 6A ?? 8D 8D ?? ?? ?? ?? 51 6A ?? FF D0 85 C0 0F 84 ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? B8 ?? ?? ?? ?? 5F 5E 8B 4D ?? 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 8B 4D ?? 5F 33 
            CD 33 C0 5E E8 ?? ?? ?? ?? 8B E5 5D C3
        }

        $file_search_4_1b_1 = {
            E8 ?? ?? ?? ?? 83 C4 ?? 8D 85 ?? ?? ?? ?? 50 6A ?? 6A ?? 6A ?? 6A ?? FF 15 ?? ?? ?? 
            ?? 8D 8D ?? ?? ?? ?? 6A ?? 51 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 08 83 C4 ?? 68 ?? ?? 
            ?? ?? 8D 95 ?? ?? ?? ?? 52 51 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15
        }

        $file_search_4_1b_2 = {
            E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 6A ?? 6A ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? 
            ?? 50 FF 15 ?? ?? ?? ?? 8B F0 FF 15 ?? ?? ?? ?? 56 8B F8 FF 15 ?? ?? ?? ?? 83 FF ?? 
            0F 85 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 8B 48 ?? 8D 95 ?? ?? ?? ?? 52 
            51 8D 95 ?? ?? ?? ?? 52 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 8B 3D ?? ?? 
            ?? ?? 8B 1D 
        }

        $file_search_4_1b_3 = {
            E8 ?? ?? ?? ?? 83 C4 ?? 8D 4D ?? 51 8D 55 ?? 52 6A ?? 6A ?? 6A ?? 6A ?? B8 ?? ?? ?? 
            ?? 6A ?? 66 89 45 ?? 89 45 ?? 6A ?? 8D 85 ?? ?? ?? ?? 50 6A ?? C7 45 ?? ?? ?? ?? ?? 
            FF D3 85 C0 74 ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 
        }

        $server_communication_4_1b_1 = {
            55 8B EC 83 E4 ?? B8 ?? ?? ?? ?? E8
        }

        $server_communication_4_1b_2 = {
            E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 8B 42 ?? 83 C4 ?? ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 
            89 44 24 ?? 3B C3 75 ?? ?? ?? B8 ?? ?? ?? ?? ?? 8B E5 5D C2 ?? ?? 68 ?? ?? ?? ?? 8D 
            ?? 24 ?? ?? ?? ?? 53 51 E8 ?? ?? ?? ?? 0F B6 ?? ?? ?? ?? ?? 0F B6 ?? ?? ?? ?? ?? 0F 
            B6 ?? ?? ?? ?? ?? 83 C4 0C
        }

        $server_communication_4_1b_3 = {
            8A 08 ?? ?? ?? 75 ?? 2B C6 50 57 8D ?? 24 ?? E8 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 
            8B CF 51 C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 
            44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 83 C4 ?? 8D 78 ?? 8A 08 40 
            3A CB 75 ?? 2B C7 8B C8 8D 51 ?? 83 E2 ?? B8 ?? ?? ?? ?? 2B C2 50 50 8D 7C 01 ?? 8D 
            84 0C ?? ?? ?? ?? 50 E8 
        }

        $server_communication_4_1b_4 = {
            FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8B 84 24 ?? ?? ?? ?? 3B C3 76 ?? 8B 94 24 
            ?? ?? ?? ?? 50 52 8D 84 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8B 
            84 24 ?? ?? ?? ?? 3B C3 76 ?? 8B 8C 24 ?? ?? ?? ?? 50 51 8D 94 24 ?? ?? ?? ?? 68 ?? 
            ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 8B 4C 24 ?? 53 53 6A ?? 53 53 6A ?? 8D 84 24 ?? 
            ?? ?? ?? 50 51 FF 15 ?? ?? ?? ?? 8B F0 89 74 24 ?? 3B F3 0F 84 ?? ?? ?? ?? 6A ?? 8D 
            54 24 ?? 52 6A ?? 56 C7 44 24 ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 48 
            ?? 8B 40 ?? 53 68 ?? ?? ?? ?? 51 53 53 8D 94 24 ?? ?? ?? ?? 52 50 56 FF 15
        }

        $server_communication_4_1b_5 = {
            FF 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? 8D 44 24 ?? 50 68 ?? ?? ?? ?? 8D 8C 
            24 ?? ?? ?? ?? 51 56 FF 15 ?? ?? ?? ?? 8B 44 24 ?? 8B 15 ?? ?? ?? ?? 88 9C 04 ?? ?? 
            ?? ?? 88 9C 04 ?? ?? ?? ?? 8B 42 ?? 50 8D 84 24 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 
            ?? 85 C0 75 ?? 56 8B 35 ?? ?? ?? ?? FF D6 8B 4C 24 ?? 51 FF D6 8B 7C 24 ?? 47 89 7C 
            24 ?? 83 FF ?? 0F 8C ?? ?? ?? ?? 8B 54 24 ?? 52 FF 15 ?? ?? ?? ?? 6A ?? FF 15
        }

        $file_search_4_2_1 = {
            E8 ?? ?? ?? ?? 83 C4 ?? 8D 85 ?? ?? ?? ?? 50 6A ?? 6A ?? 6A ?? 6A ?? FF 15 ?? ?? ?? 
            ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? FF 30 FF 15 ?? ?? ?? ?? 68 ?? 
            ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? 
            FF 70 ?? 8D 85 ?? ?? ?? ?? 50 FF D3 83 C4 ?? 8D 85 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 6A 
            ?? 6A ?? 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B F0 FF 15 ?? ?? ?? ?? 56 8B F8 FF 15 
        }

        $file_search_4_2_2 = {
            FF D3 8B 35 ?? ?? ?? ?? 83 C4 ?? 8B 3D ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 6A ?? 8D 85 ?? 
            ?? ?? ?? 50 68 ?? ?? ?? ?? FF D6 6A ?? 8D 85 ?? ?? ?? ?? 50 FF D7 6A ?? 8D 45 ?? 6A 
            ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? C7 45 ?? ?? ?? ?? ?? B8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 
            66 89 45 ?? 89 45 ?? 8D 45 ?? 50 8D 45 ?? 50 6A ?? 6A ?? 6A ?? 6A ?? 6A ?? 6A ?? 51 
            6A ?? FF D3 
        }

        $server_communication_4_2_1 = {
            FF 15 ?? ?? ?? ?? 8B F0 0F 57 C0 8D 84 24 ?? ?? ?? ?? 66 0F 7F 84 24 ?? ?? ?? ?? 50 
            8D 84 24 ?? ?? ?? ?? 8B D6 50 68 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 
            8B CE E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 56 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 
            56 FF 15 
        }

        $server_communication_4_2_2 = {
            FF D7 8B 0D ?? ?? ?? ?? 8B D0 8B 49 ?? E8 ?? ?? ?? ?? 83 C4 ?? C7 44 24 ?? ?? ?? ?? 
            ?? 8D 84 24 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? 
            ?? ?? ?? ?? 50 8D 84 24 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 84 24 ?? ?? ?? ?? 
            50 FF D7 
        }

        $server_communication_4_2_3 = {
            6A ?? 8D 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? 50 6A ?? 56 FF 54 24 ?? 8B 0D ?? ?? ?? ?? 
            6A ?? 68 ?? ?? ?? ?? 8D 41 ?? 50 6A ?? 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 FF 71 
            ?? 56 FF 54 24 
        }

        $server_communication_4_2_4 = {
            FF 54 24 ?? 8B 44 24 ?? 66 C7 84 04 ?? ?? ?? ?? ?? ?? A1 ?? ?? ?? ?? FF 70 ?? 8D 84 
            24 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 57 8B 7C 24 ?? FF D7 56 FF 
            D7 
        }

        $server_communication_4_2_5 = {
            57 8B 7C 24 ?? FF D7 56 FF D7 FF 74 24 ?? FF D7 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 
            6A ?? FF 15 
        }

        $server_communication_3_1 = {
            8A 08 40 3A CB 75 ?? 2B C7 50 8D 94 24 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 83 C4 ?? 8D 
            44 24 ?? 50 8D 8C 24 ?? ?? ?? ?? 51 C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? 
            ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 83 C4 ?? 8D ?? ?? EB
        }

        $server_communication_3_2 = {
            68 ?? ?? ?? ?? 88 9C 04 ?? ?? ?? ?? 51 88 9C 04 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 C4 
            ?? 85 C0 75 ?? 57 8B 3D ?? ?? ?? ?? FF D7 56 FF D7 8B 7C 24 ?? 83 C7 ?? 89 7C 24 ?? 
            81 FF ?? ?? ?? ?? 0F 8C ?? ?? ?? ?? 8B 54 24 ?? 52 FF 15 ?? ?? ?? ?? 39 1D ?? ?? ?? 
            ?? 75 ?? 8B 44 24 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? FF 15 
        }

        $file_search_3_1 = {
            55 8B EC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? [0-1] 56 57 33 C0 
            68 ?? ?? ?? ?? 50 8D 8D ?? ?? ?? ?? 51 66 89 85 ?? ?? ?? ?? E8
        }

        $file_search_3_1_1 = {
            FF 15 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 EB ?? 
            FF 15 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 BA ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 6A ?? 6A ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? 
            ?? ?? 50 FF 15 ?? ?? ?? ?? 8B F0 FF 15 ?? ?? ?? ?? 56 8B F8 FF 15 
        }

        $file_search_3_1_2 = {
            8B 35 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 83 C4 ?? 6A ?? 8D 85 ?? ?? ?? 
            ?? 50 68 ?? ?? ?? ?? FF D6 6A ?? 8D 8D ?? ?? ?? ?? 51 FF D7 6A ?? 8D 95 ?? ?? ?? ?? 
            6A ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 8D 8D ?? ?? ?? ?? 51 8D 95 ?? ?? ?? ?? 52 6A ?? 6A 
            ?? 6A ?? 6A ?? B8 ?? ?? ?? ?? 6A ?? 66 89 85 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 6A ?? 8D 
            85 ?? ?? ?? ?? 50 6A ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? FF D3 85 C0 74 ?? E8  
        }
        $file_search_3_2_1 = {
            68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 
            50 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 6A ?? 6A ?? 6A ?? 6A ?? 68 ?? ?? ?? 
            ?? 8D 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 8B F0 FF 15 ?? ?? ?? ?? 56 8B F8 FF 15 ?? 
            ?? ?? ?? 83 FF ?? 0F 85 
        }

        $file_search_3_2_2 = {
            8B 35 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 83 C4 ?? 6A ?? 8D 8D ?? ?? ?? ?? 51 68 ?? ?? ?? 
            ?? FF D6 6A ?? 8D 95 ?? ?? ?? ?? 6A ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 8D 8D ?? ?? ?? ?? 
            51 8D 95 ?? ?? ?? ?? 52 6A ?? 6A ?? 6A ?? 6A ?? B8 ?? ?? ?? ?? 6A ?? 66 89 85 ?? ?? 
            ?? ?? 89 85 ?? ?? ?? ?? 6A ?? 8D 85 ?? ?? ?? ?? 50 6A ?? C7 85 ?? ?? ?? ?? ?? ?? ?? 
            ?? FF D7 85 C0 74 ?? E8 
        }

        $search_and_encrypt_3_1 = {
            8B C3 83 C4 ?? 8D 50 ?? [1-3] 66 8B 08 83 C0 ?? 66 85 C9 75 ?? 2B C2 D1 F8 83 F8 ?? 76 
            ?? 68 ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? 68 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 8D ?? 
            ?? ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? 68 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 8D 8D ?? 
            ?? ?? ?? B8 ?? ?? ?? ?? 66 8B 10 66 3B 11 75 ?? 66 85 D2 74 ?? 66 8B 50 ?? 66 3B 51 
            ?? 75 ?? 83 C0 ?? 83 C1 ?? 66 85 D2 75 ?? 33 C0 EB
        }

        $search_and_encrypt_3_2 = {
            1B C0 83 D8 ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? B8 ?? ?? ?? ?? 66 8B 10 66 
            3B 11 75 ?? 66 85 D2 74 ?? 66 8B 50 ?? 66 3B 51 ?? 75 ?? 83 C0 ?? 83 C1 ?? 66 85 D2 
            75 ?? 33 C0 EB ?? 1B C0 83 D8 ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? B8 ?? ?? 
            ?? ?? 90 66 8B 10 66 3B 11 75 ?? 66 85 D2 74 ?? 66 8B 50 ?? 66 3B 51 ?? 75 ?? 83 C0 
            ?? 83 C1 ?? 66 85 D2 75 ?? 33 C0 
        }

        $search_and_encrypt_3_3 = {
            1B C0 83 D8 ?? 85 C0 0F 84 ?? ?? ?? ?? 8B ?? ?? ?? 8D ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 8D ?? ?? ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? 68 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 
            8D ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 83 7D ?? ?? 0F 85 ?? ?? ?? ?? 53 
            8D ?? ?? ?? ?? ?? 68 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 8D ?? ?? 
            ?? ?? ?? 68 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 8D ?? ?? ?? ?? ?? ?? 8D ?? ?? ?? 
            ?? ?? 68 ?? ?? ?? ?? ?? E8 
        }

        $search_and_encrypt_3_4 = {
            E8 ?? ?? ?? ?? 83 C4 ?? 8B F0 57 56 E8 ?? ?? ?? ?? 83 C4 ?? B8 ?? ?? ?? ?? 8B CE E8 
            ?? ?? ?? ?? 85 C0 75 ?? B8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 85 C0 75 ?? 8B C6 E8 ?? 
            ?? ?? ?? 83 F8 ?? 75 ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 56 E8 
        }

    condition:
        uint16(0) == 0x5A4D and
        (($file_search_0_3_1_1 and $file_search_0_3_1_2 and $encrypt_file_0_2_6a_1 and $encrypt_file_0_2_6a_2 and $server_communication_0_2_6a_1 and $server_communication_0_2_6a_2) or
        ($file_search_0_3_1_1 and $file_search_0_3_1_2 and $encrypt_file_0_3_1 and $server_communication_0_3_1_1 and $server_communication_0_3_1_2) or
        ($file_search_0_3_3_1 and $file_search_0_3_3_2 and $encrypt_file_0_3_3_1 and $encrypt_file_0_3_3_2 and $server_communication_0_3_3_1 and $server_communication_0_3_3_2) or
        ($file_search_0_3_4a_1 and $file_search_0_3_4a_2 and $encrypt_file_0_3_4a_1 and $encrypt_file_0_3_4a_2 and $server_communication_0_3_4a_1 and $server_communication_0_3_4a_2) or
        ($file_search_0_3_5a_1 and $file_search_0_3_5a_2 and $encrypt_file_0_3_5a_1 and $encrypt_file_0_3_5a_2 and $server_communication_0_3_5a_1 and $server_communication_0_3_5a_2) or
        ($server_communication_2_0_4e and $search_and_encrypt_2_0_4e_1 and $search_and_encrypt_2_0_4e_2 and $search_and_encrypt_2_0_4e_3 and
        $search_and_encrypt_2_0_4e_4 and $search_and_encrypt_2_0_4e_5) or
        ($server_communication_4_0_1 and $server_communication_4_0_2 and $server_communication_4_0_3 and $file_search_4_0_1 and $file_search_4_0_2 and
        $file_search_4_0_3) or
        ($file_search_4_1b_1 and $file_search_4_1b_2 and $file_search_4_1b_3 and $server_communication_4_1b_1 and $server_communication_4_1b_2 and
        $server_communication_4_1b_3 and $server_communication_4_1b_4 and $server_communication_4_1b_5) or
        ($file_search_4_2_1 and $file_search_4_2_2 and $server_communication_4_1b_1 and $server_communication_4_2_1 and $server_communication_4_2_2 and
        $server_communication_4_2_3 and $server_communication_4_2_4 and $server_communication_4_2_5) or
        ($server_communication_4_0_1 and $server_communication_3_1 and $server_communication_3_2 and $file_search_3_1 and $file_search_3_1_1 and $file_search_3_1_2 and $search_and_encrypt_3_1 and $search_and_encrypt_3_2 and $search_and_encrypt_3_3 and $search_and_encrypt_3_4) or
        ($server_communication_4_0_1 and $server_communication_3_1 and $server_communication_3_2 and $file_search_3_1 and $file_search_3_2_1 and $file_search_3_2_2 and $search_and_encrypt_3_1 and $search_and_encrypt_3_2 and $search_and_encrypt_3_3 and $search_and_encrypt_3_4))
}